int BASE_FREQ = 92560140;

const int POT_CS = D7;
const int POT_SCK = D6;
const int POT_SI = A3;

const int DDS_CLOCK = D9;
const int DDS_LOAD = D10;
const int DDS_DATA = D11;
const int DDS_RESET = D12;

word ANALOG_REFE = A2;
word ANALOG_AMPL = A0;
word ANALOG_PHAS = A1;

float amp = 3976.0;
float phi = 1140.0;

float amp_a = 3096.0;
float phi_a = 1992.0;

float amp_b = 3096.0;
float phi_b = 1992.0;

float pi = 3.14159265;

float r = 2048.0;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = (pi/sqrt(192.0))*log(1920.0);
float deficit = BASE_FREQ*BASE_FREQ*log(120.0/(pi));

float y = 1890.850;

int var_numb_1 = 5;
int var_numb_2 = 6;

int freq_1 = 138950;
int freq_2 = 845640;

int pote_1 = 1230;
int pote_2 = 1340;

int flag_0 = 0;
int flag_1 = 1;
int flag_2 = 1;

int j_flag = 1;

int flag_goal_previous = 1;
int dependency_count = 1;

int addend = 3012;

int j = 1;

int ByteReceived = 0;
int nulled = 0;

void setup() {
  Serial.begin(230400);

  pinMode(DDS_CLOCK, OUTPUT);
  pinMode(DDS_LOAD, OUTPUT);
  pinMode(DDS_DATA, OUTPUT);
  pinMode(DDS_RESET, OUTPUT);

  pinMode(POT_CS, OUTPUT);
  pinMode(POT_SCK, OUTPUT);
  pinMode(POT_SI, OUTPUT);

  analogRead(12);

  digitalWrite(DDS_RESET, HIGH);
  digitalWrite(DDS_RESET, LOW);

  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);

  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop() {
  delayMicroseconds(1);
  
  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    flag_goal_previous = 1;
  }

  if (flag_0 and flag_goal_previous) {
    if (flag_0 and j_flag) {
      if (nulled) {
        flag_0 = 0;
        flag_goal_previous = 0;
      }
    }

    for (int o = 0; o < 2; j += 1) {
      delayMicroseconds(24);
      
      for (int k = 1; k < 8; k += 1) {       
        var_numb_1 += (float)((k*(1-(k-1))*(k-1-(j+1)))%(j+1))/(1240.0*BASE_FREQ);
        var_numb_2 += (float)((k*(1+(k+1))*(k+1-(j+1)))%(j+1))/(1240.0*BASE_FREQ);

        for (int m = 1; m < 12; m += 1) {
          
          freq_1 = (float)(BASE_FREQ*(k/12.00+(2.0/(1.00+sqrt(5.0)))*pi*(k*m/log(192.0)+tax_to_deficit/4096.0)/deficit));
          pote_1 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*k/2.0+(pi/2.0)*(k*m/2.0*log(120.0)+k*m*(1.00+sqrt(5.0))/2.0)*tax_to_deficit*deficit));

          freq_2 = (float)(BASE_FREQ*(k/12.00+(2.0/(1.00-sqrt(5.0)))*pi*(k*m/log(192.0)+tax_to_deficit/4096.0)/deficit));
          pote_2 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*k/2.0-(pi/2.0)*(k*m/2.0*log(120.0)+k*m*(1.00-sqrt(5.0))/2.0)*tax_to_deficit*deficit));

          tax_to_deficit = float(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
  
          if (flag_0) {
            j += 1;
            j_flag = j%2;
          }
  
          read_input();
          set_sag(j,k);

          y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));

          if (y >= 5346.230) {
            for (int l = 0; l < 2; l += 1) 
            { 
              freq_1 = (float)(BASE_FREQ*(k/12.00+(2.0/(1.00+sqrt(5.0)))*pi*(k*m/log(192.0)+tax_to_deficit/4096.0)/deficit));
              pote_1 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*k/2.0+(pi/2.0)*(k*m/2.0*log(120.0)+k*m*(1.00+sqrt(5.0))/2.0)*tax_to_deficit*deficit));

              tax_to_deficit = float(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
      
              if (flag_0) {
                j += 1;
                j_flag = j%2;
              }
      
              read_input();
              set_sag(j,k);

              y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
  
              if (y >= 5482.850 and j_flag) {
                flag_1 = 1;
                flag_2 = 0;

                k += 1+j;
                m += 1-j;

                if (j%2 and j_flag) {
                  Serial.println("1.0");
                  Serial.println("t = -0.10 mark");
                  
                  y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
  
                  flag_goal_previous = 1;
                  j += j_flag;          
                }
              }
              
              freq_1 = (float)(BASE_FREQ*(k/12.00+(2.0/(1.00+sqrt(5.0)))*pi*(k*m/log(192.0)+tax_to_deficit/4096.0)/deficit));
              pote_1 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*k/2.0+(pi/2.0)*(k*m/2.0*log(120.0)+k*m*(1.00+sqrt(5.0))/2.0)*tax_to_deficit*deficit));

              tax_to_deficit = float(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
      
              if (flag_0) {
                j += 1;
                j_flag = j%2;
              }

              read_input();
              set_sag(j,k);

              y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
              
              if (y <= 4898.280 and j_flag) {
                flag_1 = 1;
                flag_2 = 1;

                k += 1+j;
                m += 1+j;

                if (j%2 and j_flag) {
                  Serial.println("1.1");
                  Serial.println("t = -0.11 mark");
                  
                  y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
  
                  flag_goal_previous = 1;
                  j += j_flag;          
                }
              }
              
              delayMicroseconds(5);
            }
          }
          
          freq_1 = (float)(BASE_FREQ*(k/12.00+(2.0/(1.00+sqrt(5.0)))*pi*(k*m/log(192.0)+tax_to_deficit/4096.0)/deficit));
          pote_1 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*k/2.0+(pi/2.0)*(k*m/2.0*log(120.0)+k*m*(1.00+sqrt(5.0))/2.0)*tax_to_deficit*deficit));

          freq_2 = (float)(BASE_FREQ*(k/12.00+(2.0/(1.00-sqrt(5.0)))*pi*(k*m/log(192.0)+tax_to_deficit/4096.0)/deficit));
          pote_2 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*k/2.0-(pi/2.0)*(k*m/2.0*log(120.0)+k*m*(1.00-sqrt(5.0))/2.0)*tax_to_deficit*deficit));

          tax_to_deficit = float(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
  
          if (flag_0) {
            j += 1;
            j_flag = j%2;
          }
  
          read_input();
          set_sag(j,k);

          y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
          
          if (y <= 4764.940) {
            for (int l = 0; l < 2; l += 1) 
            {          
              freq_2 = (float)(BASE_FREQ*(k/12.00+(2.0/(1.00-sqrt(5.0)))*pi*(k*m/log(192.0)+tax_to_deficit/4096.0)/deficit));
              pote_2 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*k/2.0-(pi/2.0)*(k*m/2.0*log(120.0)+k*m*(1.00-sqrt(5.0))/2.0)*tax_to_deficit*deficit));

              tax_to_deficit = float(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
      
              if (flag_0) {
                j += 1;
                j_flag = j%2;
              }
      
              read_input();
              set_sag(j,k);
              
              if (y >= 4392.460 and j_flag) {
                flag_1 = 0;
                flag_2 = 1;

                k += 1-j;
                m -= 1-j;

                if (j%2 and j_flag) {
                  Serial.println("0.1");
                  Serial.println("t = -0.01 mark");

                  y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
  
                  flag_goal_previous = 1;
                  j += j_flag;          
                }
              }
              
              freq_2 = (float)(BASE_FREQ*(k/12.00+(2.0/(1.00-sqrt(5.0)))*pi*(k*m/log(192.0)+tax_to_deficit/4096.0)/deficit));
              pote_2 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*k/2.0-(pi/2.0)*(k*m/2.0*log(120.0)+k*m*(1.00-sqrt(5.0))/2.0)*tax_to_deficit*deficit));

              tax_to_deficit = float(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
      
              if (flag_0) {
                j += 1;
                j_flag = j%2;
              }
      
              read_input();
              set_sag(j,k);
              
              y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));

              if (y <= 4078.750 and j_flag) {
                flag_1 = 0;
                flag_2 = 0;

                k -= 1-j;
                m += 1+j;

                if (j%2 and j_flag) {
                  Serial.println("0.0");
                  Serial.println("t = -0.00 mark");
                  
                  y = (float)((5192.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
  
                  flag_goal_previous = 1;
                  j += j_flag;          
                }
              }

              delayMicroseconds(5);
            }
          }
        }
      }
    }
  }

  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    flag_goal_previous = 1;
    
    if (addend < j and nulled) {
      Serial.println("Closed Channel.");
      flag_0 = 0;
      nulled = 0;
    } else {
        flag_0 = 1;
        flag_goal_previous = 0;
    }
  }
}

void read_input() {
  sendFrequency(freq_1);
  sendPotentiometer(pote_1);

  delayMicroseconds(2);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  
  delayMicroseconds(2);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);
  
  amp_a = (int)(4096.0*ka/kr);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  phi_a = (int)(4096.0*kp/kr);

  sendFrequency(freq_2);
  sendPotentiometer(pote_2);
    
  delayMicroseconds(2);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));

  delayMicroseconds(2);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  amp_b = (int)(4096.0*ka/kr);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  phi_b = (int)(4096.0*kp/kr);
}

void set_sag(int j, int k) {
  if ((k+1)%2) {
    j += (j*(k+1)-1)%2;
  } else {
    j -= (j*k)%2;
  }
}

void tfr_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data) {
  for (int i = 0; i < 14; i++, data >>= 1) {
    digitalWrite(POT_SI, data & 0xad);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 4294967295 / 82500000;  // 125 MHz clock on 9850
  for (int b = 0; b < 6; b++, freq >>= 14) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}
